/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.scripting.ScriptLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ScriptUtils {
    public static final String RUBLE_MODULE = "Ruble";
    public static final IRubyObject[] NO_ARGS = new IRubyObject[0];

    private ScriptUtils() {
    }

    public static IRubyObject instantiateClass(Ruby runtime, String name, IRubyObject ... args) {
        ThreadContext threadContext = runtime.getCurrentContext();
        IRubyObject result = null;
        RubyClass rubyClass = runtime.getClass(name);
        if (rubyClass != null) {
            result = rubyClass.newInstance(threadContext, args, Block.NULL_BLOCK);
        }
        return result;
    }

    public static IRubyObject instantiateClass(Ruby runtime, String module, String name, IRubyObject ... args) {
        RubyClass rubyClass;
        ThreadContext threadContext = runtime.getCurrentContext();
        IRubyObject result = null;
        RubyModule rubyModule = runtime.getModule(module);
        if (rubyModule != null && (rubyClass = rubyModule.getClass(name)) != null) {
            result = rubyClass.newInstance(threadContext, args, Block.NULL_BLOCK);
        }
        return result;
    }

    public static void logErrorWithStackTrace(String message, Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        ScriptLogger.logError(String.valueOf(message) + "\n" + stringWriter.toString());
    }
}

